REM     PROGRAM SUPRASIM


        ver$ = "1.02, 25-12-2021"

REM     latest update by Nomdo Jansonius on abovementioned date

REM     SUPRASIM is a suprathreshold version of PERISIM

REM     Ga uit van een venster met verhouding 4:3 (800x600 of 1024x768 geeft
REM     1.33 = 4:3; 1280x1024 geeft 1.25). Instructie voor gebruik is dat de 
REM     afstand van oog tot scherm gelijk moet zijn aan de vensterdiagonaal.
REM     Dan haal je langs de vensterdiagonaal 26.6 graden eccentriciteit, en
REM     daarmee horizontaal 21.3 en vertikaal 15.9 graden. Aangezien stimuli 
REM     niet helemaal tot aan de rand mogen, is het max. 18 resp. 12 graden.
REM     In full-screen mode (Alt-Enter) met 16:9 monitor wordt het 23.2/13.0 
REM     i.p.v. 21.3/15.9 graden, waarmee de stimuli horizontaal 9% verder en
REM     vertikaal 18% dichterbij liggen dan bedoeld.

REM     version history

REM     1.02  first public release (version 'kerstmis')

        ntl% = 25                       REM number of test locations

        DIM tlx%(1 to ntl%)             REM x-cordinates of the test locations
        DIM tly%(1 to ntl%)             REM y-cordinates of the test locations
        DIM seen%(1 to ntl%)            REM y/n seen in concerning test location

REM     select appropriate window size
100     SCREEN 0
        COLOR 15,3
        CLS
        PRINT ""
        COLOR 0,3
        PRINT "  SUPRASIM -- suprathreshold perimetry on a computer monitor" 
        PRINT ""
        PRINT ""
        COLOR 15,3
        PRINT "  choose window size: (1) = small, (2) = medium, (3) = large"
        PRINT ""
        PRINT "  choose the largest window that fits entirely on the screen"
        PRINT ""
        PRINT ""
        COLOR 0,3
        PRINT "  choose h for the specifications and calibration, q to quit"
        PRINT ""
        DO
          keuze$ = INKEY$
        LOOP WHILE keuze$ = ""
        IF keuze$ = "1" THEN
          screenkeuze% = 19
          xres% = 800
          yres% = 600
          COLOR 7,0
          CLS
          PRINT ""
          PRINT "  to interrupt the test at any point in time, return to this"
          PRINT "  window and press Ctrl-C"
          GOTO 120
        ELSEIF keuze$ = "2" THEN 
          screenkeuze% = 20
          xres% = 1024
          yres% = 768
          COLOR 7,0
          CLS
          PRINT ""
          PRINT "  to interrupt the test at any point in time, return to this"
          PRINT "  window and press Ctrl-C"
          GOTO 120
        ELSEIF keuze$ = "3" THEN 
          screenkeuze% = 21
          xres% = 1280
          yres% = 1024
          COLOR 7,0
          CLS
          PRINT ""
          PRINT "  to interrupt the test at any point in time, return to this"
          PRINT "  window and press Ctrl-C"
          GOTO 120
        ELSEIF keuze$ = "h" THEN 
          GOTO 110
        ELSEIF keuze$ = "q" THEN
          GOTO 890
        ELSE
          GOTO 100
        ENDIF

REM     specs and calibration
110     SCREEN 19
        COLOR 1,31
        CLS                             REM needed to get a uniform background color
        PRINT ""
        PRINT "  SUPRASIM is *NOT* a medical device; it's an open source programme for lecturing perimetry"
        PRINT ""
        PRINT ""
        PRINT "  specifications"
        PRINT ""
        PRINT "    psychophysical method           :   single contrast roughly 6 dB above hill of vision"
        PRINT "                                        of the author; stimulus repeated once if not seen"
        PRINT "    stimulus size / duration / type :   Goldmann size III / 200 ms / decrement"
        PRINT "    Weber contrast (eccentricity)   :   -1.0 (> 10 deg), -0.5 (< 10 deg), -0.2 (fovea)"
        PRINT ""
        PRINT ""
        PRINT "  calibration"
        PRINT ""
        PRINT "    the relative luminance in the squares below has to be approximately 1 - 0.80 - 0.50 - 0"
        PRINT ""
        PRINT "    (if not, the programme can still be used but the reported results may be less accurate)"
        PRINT ""
        PRINT ""
	PRINT ""
        PRINT "  press b to go back to previous screen"
REM     kader
        LINE (100,375)-(700,375),1 
        LINE (100,525)-(700,525),1
        LINE (100,375)-(100,525),1
        LINE (700,375)-(700,525),1
REM     binnengrenzen
        LINE (250,375)-(250,525),1
        LINE (400,375)-(400,525),1
        LINE (550,375)-(550,525),1
REM     inkleuring
        PAINT (150,450),28,1
        PAINT (300,450),27,1
        PAINT (450,450),25,1
        PAINT (600,450),16,1
        PRINT ""
        PRINT ""
        PRINT ""
        PRINT ""
        PRINT ""
        PRINT ""
        PRINT ""
        PRINT ""
        PRINT ""
        PRINT ""
        PRINT ""
        PRINT ""
        PRINT ""        
        PRINT ""
        PRINT "  version ",ver$,"            author: Nomdo Jansonius (c) 2021-2066"
115     DO
          keuze$ = INKEY$
        LOOP WHILE keuze$ = ""
        IF keuze$ = "b" THEN
          SCREEN 0
          GOTO 100
        ELSE
          GOTO 115
        ENDIF        

120     SCREEN screenkeuze%
        COLOR 1,28
        CLS                             REM CLS needed here to get a uniform background color
        PRINT ""
        PRINT ""        
        PRINT "    press b to go back to previous screen for selecting another window size"
        PRINT ""
        LINE (10,yres%-10)-(xres%-10,10),1
        CIRCLE (7,yres%-7),5,1
        CIRCLE (xres%-7,7),5,1
        PAINT (7,yres%-7),1,1
        PAINT (xres%-7,7),1,1
        PRINT ""
        PRINT "    make testing distance equal to diagonal size of selected window"
        PRINT ""
        PRINT ""
        PRINT "    cover one eye"
        PRINT ""
        PRINT "    look at the middle of the circle on the next screen"
        PRINT ""
        PRINT "    each time a stimulus is seen, press spacebar"
        PRINT ""
        PRINT "    the test takes between 1.5 and 3 minutes"
        PRINT ""
        PRINT ""
        PRINT ""
        PRINT "    ready? press spacebar to start"
130     DO
          keuze$ = INKEY$
        LOOP WHILE keuze$ = ""
        IF keuze$ = "b" THEN
          SCREEN 0
          GOTO 100
        ENDIF
        
        CLS
REM     draw a circle with radius 1 deg as fixation target 
        xecc! = 0
        yecc! = 0
        GOSUB 940
        CIRCLE (xpos%,ypos%),xres%/42.6,1
	SLEEP(3)

REM     test locations (based on "jansonius-map"; made symmetrical L/R eye)
        tlx%(1) =   0
        tly%(1) =   0
        tlx%(2) =  10
        tly%(2) =  12
        tlx%(3) = -10 
        tly%(3) = -12
        tlx%(4) =  10
        tly%(4) = -12
        tlx%(5) = -10
        tly%(5) =  12
        tlx%(6) =   2 
        tly%(6) =   2
        tlx%(7) =  -2
        tly%(7) =  -2
        tlx%(8) =   2
        tly%(8) =  -2
        tlx%(9) =  -2
        tly%(9) =   2
        tlx%(10) =  18
        tly%(10) =   4
        tlx%(11) = -18
        tly%(11) =  -8
        tlx%(12) =  18
        tly%(12) =  -8
        tlx%(13) = -18
        tly%(13) =   4
        tlx%(14) =   6 
        tly%(14) =   2
        tlx%(15) =  -6
        tly%(15) =  -2
        tlx%(16) =   6
        tly%(16) =  -2
        tlx%(17) =  -6
        tly%(17) =   2
        tlx%(18) =  15                  REM blind spot OD (if changed: update mean sensitivity calculation)
        tly%(18) =  -2
        tlx%(19) = -15                  REM blind spot OS (if changed: update mean sensitivity calculation)
        tly%(19) =  -2
        tlx%(20) =   2
        tly%(20) =   8
        tlx%(21) =  -2
        tly%(21) =  -8
        tlx%(22) =   2
        tly%(22) =  -8
        tlx%(23) =  -2
        tly%(23) =   8
        tlx%(24) =  12
        tly%(24) =   4
        tlx%(25) = -12
        tly%(25) =   4

REM     perimetrie in engere zin
        t0$ = TIME$
        fpcount% = 0                    REM number of FP responses counted during test
        FOR i% = 1 TO ntl%              REM i% denotes the test location
        xecc! = tlx%(i%)
        yecc! = tly%(i%)
        GOSUB 940
REM     defining stimulus contrast depending on eccentricity
        ecc! = SQR(xecc!*xecc!+yecc!*yecc!)
        IF ecc! < 0.5 THEN stim% = 1
        IF ecc! > 0.5 THEN stim% = 2
        IF ecc! > 10 THEN stim% = 3
        GOSUB 930                       REM present stimulus
        GOSUB 920                       REM wait for response
        IF antwoord$ <> "" THEN
          seen%(i%) = 1                 REM stimulus seen
          GOTO 150
        ELSE
          GOTO 140                      REM stimulus not seen
        ENDIF  
140     GOSUB 930                       REM present stimulus again
        GOSUB 920                       REM wait for response
        IF antwoord$ <> "" THEN
          seen%(i%) = 1                 REM repeated stimulus seen
          GOTO 150
        ELSE
          seen%(i%) = 0                 REM stimulus definitively not seen
          GOTO 150
        ENDIF          
 
REM     probing false positive responses
150     IF i% = 3 OR i% = 8 OR i% = 14 THEN
          stim% = 0
          GOSUB 930
          GOSUB 920
          IF antwoord$ <> "" THEN fpcount% = fpcount%+1         
        ENDIF
REM     some rest before going to the next test location
        SLEEP(0.0)                      REM no rest was best
        NEXT i%                         REM einde van perimetrie in engere zin
        SLEEP(1.0)                      REM before closing perimetry window/screen

        t1$ = TIME$

REM     collecting some information for graphical report and output datafile
500     SCREEN 0
        COLOR 0,3
        CLS
        PRINT ""
        PRINT "  which eye was tested: OD (r) or OS (l)?"
        DO
          keuze$ = INKEY$
        LOOP WHILE keuze$ = ""
        IF keuze$ = "r" THEN
          oog$ = "OD"
        ELSEIF keuze$ = "l" THEN
          oog$ = "OS"
        ELSE
          GOTO 500
        ENDIF
        PRINT ""
        PRINT "  tested eye:",oog$
        PRINT ""
        PRINT "  comment to include in output (single line; no , allowed):"
        PRINT ""
        INPUT commentaar$
        
REM     nicer FP response presentation
        IF fpcount% = 0 THEN fpcount$ = "0/3"
        IF fpcount% = 1 THEN fpcount$ = "1/3"
        IF fpcount% = 2 THEN fpcount$ = "2/3"
        IF fpcount% = 3 THEN fpcount$ = "3/3"
        
REM     calculation of number of seen points
        points% = 0
        FOR i% = 1 TO ntl%        
          points% = points% + seen%(i%)
        NEXT i%
REM     removal of blind spot value from number of seen points calculation   
        IF oog$ = "OD" THEN points% = points%-seen%(18) ELSE points% = points%-seen%(19)
REM     final value put in string for aligned presentation        
        points$ = LTRIM$(RTRIM$(STR$(points%)))
        noemer$ = LTRIM$(RTRIM$(STR$(ntl%-1)))
        breuk$ = points$+"/"+noemer$                   
        
REM     make a graphical report
600     SCREEN 19
        COLOR 1,31
        CLS                             REM needed to get a uniform background color
REM     kader rond het gezichtsveld
        LINE (20,2)-(627,2),1 
        LINE (20,395)-(627,395),1
        LINE (20,2)-(20,395),1
        LINE (627,2)-(627,395),1
        FOR i% = 1 TO ntl%
        xecc! = tlx%(i%)
        yecc! = tly%(i%)
        ecc2! = xecc!*xecc!+yecc!*yecc!
        x% = CINT(tlx%(i%)*1.88+39)     REM 40/21.3 = 1.88 
        y% = tly%(i%)*-1.0+13
        IF y% = 1 THEN
          y% = 2
        ELSEIF y% = 25 THEN
          y% = 24
        ENDIF
        LOCATE y%,x%,0
        IF seen%(i%) = 0 THEN
          COLOR 0,31
          PRINT "  X "
        ELSE
          COLOR 3,31
          PRINT "  O "
        ENDIF
        NEXT i%
        COLOR 1,31
        LOCATE 2,90
        PRINT "SUPRASIM"
        LOCATE 3,82
        PRINT ver$
        LOCATE 20,93
        PRINT oog$
        LOCATE 27,5
        PRINT "date of test            ",DATE$
        LOCATE 28,5
        PRINT "beginning of test       ",t0$
        LOCATE 29,5
        PRINT "end of test             ",t1$
        LOCATE 30,5
        PRINT "false-positive responses",fpcount$
        LOCATE 31,5
        PRINT "number of points seen   ",breuk$
        LOCATE 33,5
        COLOR 3,31
        PRINT commentaar$
        COLOR 1,31
        LOCATE 35,5
        PRINT "the program does not save this graphical report; make a"
        LOCATE 36,5
        PRINT "screenshot of the current window by using Alt-PrintScrn"
        LOCATE 35,90
        PRINT "back (b)"
        LOCATE 36,90
        PRINT "exit (e)"
610     DO
          keuze$ = INKEY$
        LOOP WHILE keuze$ = ""
        IF keuze$ = "b" THEN
          GOTO 500
        ELSEIF keuze$ = "e" THEN
          GOTO 890
        ELSE
          GOTO 610
        ENDIF

890     SCREEN 0
        COLOR 7,0
        CLS
899     PRINT ""
        PRINT "  Thank you for using SUPRASIM!"
        PRINT ""

        END


920     DO                              REM keyboard buffer leegmaken
        LOOP WHILE INKEY$ <> "" 
        SLEEP(1.5)                      REM wait until any key has been pressed but continue anyway after 1.5 seconds
        antwoord$ = INKEY$
        RETURN

REM     project stimulus with size size! relative to Goldmann size III (0.43 deg diameter) and duration delay!
REM
REM     -----------------------------------------------------------------------------------------
REM      QB45 color (gray values 16-31)    RGB value (0-63)     Weber contrast (%)         logCS
REM
REM                28                           45                 background*
REM                27                           40                     20                   0.7
REM                25                           32                     50                   0.3
REM                16                            0                    100                   0.0
REM    
REM      * = luminance of gray value 28 is ~50% of max. luminance (white; gray value 31) 
REM     -----------------------------------------------------------------------------------------

930     IF stim% = 1 THEN
          kleur% = 27                   REM Weber contrast ~ 0.20
          delay! = 0.2                  REM duration 200 ms
          size! = 1.0                   REM Goldmann size III
        ENDIF
        IF stim% = 2 THEN
          kleur% = 25                   REM Weber contrast ~ 0.50
          delay! = 0.2
          size! = 1.0
        ENDIF  
        IF stim% = 3 THEN
          kleur% = 16                   REM Weber contrast ~ 1.00
          delay! = 0.2
          size! = 1.0
        ENDIF
        IF stim% = 0 THEN
          kleur% = 28                   REM contrast = 0 for testing false-positive responses 
          delay! = 0.2
          size! = 1.0
        ENDIF  

        SLEEP(1.5)                      REM 1.5 s delay between previous stimulus/respons and next
        COLOR kleur%
        CIRCLE (xpos%,ypos%),size!*0.5*0.43*xres%/42.6
        PAINT (xpos%,ypos%),kleur%,kleur%
REM     wait delay! seconds 
        nu# = TIMER
        WHILE TIMER < nu#+delay!
        WEND 
        PAINT (xpos%,ypos%),28,28
        RETURN

REM     convert x and y eccentricity into position in window
940     xpos% = (xecc!+21.3)*xres%/42.6 REM xecc! is hor eccentricity in deg
        ypos% = (15.9-yecc!)*yres%/31.8 REM yecc! is ver eccentricity in deg
        RETURN

